%% This function is used for population updates

function [x, f, g, h, svc, svc_abs] = deb_tournament_i(i, x, f, g, h, ...
    svc, svc_abs, u, f_u, g_u, h_u, svc_u, svc_u_abs,tolerance_i, tolerance_f)

delta_svc = 0; 
delta_f = 0; 

if i == 1	
    if svc_u_abs < svc_abs(1)     
        delta_svc = svc_abs(1) - svc_u_abs; 
    elseif (svc_u_abs == 0) && (svc_abs(1) == 0) && (f_u < f(1,1))  
        delta_f = f(1,1) - f_u; 
    end
else
    if svc_u < svc(i)	% Accept currently feasible over currently infeasible (improves diversity)
        delta_svc = svc(i) - svc_u;
    elseif (svc_u == 0) && (svc(i) == 0) && (f_u < f(1,i))	% Accept currently optimal over currently sub-optimal 
        delta_f = f(1,i) - f_u; 
    elseif any(tolerance_i > tolerance_f) && (svc_u_abs <  svc_abs(i))	% Accept more feasible over infeasible 
        delta_svc = svc_abs(i) - svc_u_abs;
    end
end

delta_f = delta_f + delta_svc;

if delta_f > 0
    x(i,:) = u;
    g(i,:) = g_u;
    h(i,:) = h_u;
    f(1,i) = f_u;
    svc(i,:) = svc_u;
    svc_abs(i,:) = svc_u_abs;
end
end
